//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F18 - Constraints Quadratic Velocity Terms (Jdqd)
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

void mbs_cons_jdqd(double *Jdqd,
MbsData *s, double tsim)
{
#include "mbs_cons_jdqd_pendulum_spring_c.h"

double *q, *qd;
double **dpt, *lrod;

q = s->q;
qd = s->qd;

dpt = s->dpt;
lrod = s->lrod;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Constraints and Constraints Jacobian

 
// Constraints Quadratic Terms

RLjdqd1_12 = dpt[3][4]*S1;
RLjdqd1_32 = dpt[3][4]*C1;
ORjdqd1_12 = RLjdqd1_32*qd[1];
ORjdqd1_32 = -RLjdqd1_12*qd[1];
Apqpjdqd1_12 = ORjdqd1_32*qd[1];
Apqpjdqd1_32 = -ORjdqd1_12*qd[1];
ROjdqd2_72 = C3*S4+S3*C4;
ROjdqd2_92 = C3*C4-S3*S4;
RLjdqd2_12 = dpt[3][6]*S3;
RLjdqd2_32 = dpt[3][6]*C3;
OMjdqd2_22 = qd[3]+qd[4];
ORjdqd2_12 = RLjdqd2_32*qd[3];
ORjdqd2_32 = -RLjdqd2_12*qd[3];
Apqpjdqd2_12 = ORjdqd2_32*qd[3];
Apqpjdqd2_32 = -ORjdqd2_12*qd[3];
RLjdqd2_13 = ROjdqd2_72*dpt[3][7];
RLjdqd2_33 = ROjdqd2_92*dpt[3][7];
ORjdqd2_13 = OMjdqd2_22*RLjdqd2_33;
ORjdqd2_33 = -OMjdqd2_22*RLjdqd2_13;
Apqpjdqd2_13 = Apqpjdqd2_12+OMjdqd2_22*ORjdqd2_33;
Apqpjdqd2_33 = Apqpjdqd2_32-OMjdqd2_22*ORjdqd2_13;
jdqd1 = Apqpjdqd1_12-Apqpjdqd2_13;
jdqd3 = Apqpjdqd1_32-Apqpjdqd2_33;
Jdqd[1] = jdqd1;
Jdqd[2] = jdqd3;

// Number of continuation lines = 0

}
